var jQuery_1_8_2 = jQuery_1_8_2 || $.noConflict();
(function ($, undefined) {
	$(function () {
		var $frmCreateCity = $("#frmCreateCity"),
			$frmUpdateCity = $("#frmUpdateCity"),
			validate = ($.fn.validate !== undefined),
			datagrid = ($.fn.datagrid !== undefined);

		if ($frmCreateCity.length > 0 && validate) {
			$frmCreateCity.validate({
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em",
				ignore: "",
				invalidHandler: function (event, validator) {

				    $(".pj-multilang-wrap").each(function( index ) {
						if($(this).attr('data-index') == myLabel.localeId)
						{
							$(this).css('display','block');
						}else{
							$(this).css('display','none');
						}
					});
					$(".pj-form-langbar-item").each(function( index ) {
						if($(this).attr('data-index') == myLabel.localeId)
						{
							$(this).addClass('pj-form-langbar-item-active');
						}else{
							$(this).removeClass('pj-form-langbar-item-active');
						}
					});
				}
			});
			if(myLabel.locale_array.length > 0)
			{
				var locale_array = myLabel.locale_array;
				for(var i = 0; i < locale_array.length; i++)
				{
					var element = $("#i18n_name_" + locale_array[i]),
						locale = element.attr('lang');
					element.rules('add', {
						remote: {
							url: "index.php?controller=pjAdminCities&action=pjActionCheckCity",
							type: 'post',
							data: {locale: locale}
						},
						messages: {
					    	required: myLabel.field_required,
					    	remote: myLabel.same_city
					    }
					});
				}
			}
		}
		if ($frmUpdateCity.length > 0 && validate) {
			$frmUpdateCity.validate({
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em",
				ignore: "",
				invalidHandler: function (event, validator) {
				    $(".pj-multilang-wrap").each(function( index ) {
						if($(this).attr('data-index') == myLabel.localeId)
						{
							$(this).css('display','block');
						}else{
							$(this).css('display','none');
						}
					});
					$(".pj-form-langbar-item").each(function( index ) {
						if($(this).attr('data-index') == myLabel.localeId)
						{
							$(this).addClass('pj-form-langbar-item-active');
						}else{
							$(this).removeClass('pj-form-langbar-item-active');
						}
					});
				}
			});
			if(myLabel.locale_array.length > 0)
			{
				var locale_array = myLabel.locale_array;
				for(var i = 0; i < locale_array.length; i++)
				{
					var element = $("#i18n_name_" + locale_array[i]),
						locale = element.attr('lang'),
						id = $frmUpdateCity.find("input[name='id']").val();
					element.rules('add', {
						remote: {
							url: "index.php?controller=pjAdminCities&action=pjActionCheckCity",
							type: 'post',
							data: {id: id, locale: locale}
						},
						messages: {
					    	required: myLabel.field_required,
					    	remote: myLabel.same_city
					    }
					});
				}
			}
		}
		
		if ($("#grid").length > 0 && datagrid) {
			if (pjGrid.roleId == 4) {
				var $grid = $("#grid").datagrid({
					buttons: [{type: "view", url: "index.php?controller=pjAdminCities&action=pjActionUpdate&id={:id}"}
					          ],
					columns: [{text: myLabel.city, type: "text", sortable: true, editable: false, width: 530, editableWidth: 510},
					          {text: myLabel.status, type: "select", sortable: true, editable: false, options: [
					                                                                                     {label: myLabel.active, value: "T"}, 
					                                                                                     {label: myLabel.inactive, value: "F"}
					                                                                                     ], applyClass: "pj-status"}],
					dataUrl: "index.php?controller=pjAdminCities&action=pjActionGetCity",
					dataType: "json",
					fields: ['name', 'status'],
					paginator: {
						gotoPage: true,
						paginate: true,
						total: true,
						rowCount: true
					}
				});
			} else {
				var $grid = $("#grid").datagrid({
					buttons: [{type: "edit", url: "index.php?controller=pjAdminCities&action=pjActionUpdate&id={:id}"},
					          {type: "delete", url: "index.php?controller=pjAdminCities&action=pjActionDeleteCity&id={:id}"}
					          ],
					columns: [{text: myLabel.city, type: "text", sortable: true, editable: true, width: 530, editableWidth: 510},
					          {text: myLabel.status, type: "select", sortable: true, editable: true, options: [
					                                                                                     {label: myLabel.active, value: "T"}, 
					                                                                                     {label: myLabel.inactive, value: "F"}
					                                                                                     ], applyClass: "pj-status"}],
					dataUrl: "index.php?controller=pjAdminCities&action=pjActionGetCity",
					dataType: "json",
					fields: ['name', 'status'],
					paginator: {
						actions: [
						   {text: myLabel.delete_selected, url: "index.php?controller=pjAdminCities&action=pjActionDeleteCityBulk", render: true, confirmation: myLabel.delete_confirmation}
						],
						gotoPage: true,
						paginate: true,
						total: true,
						rowCount: true
					},
					saveUrl: "index.php?controller=pjAdminCities&action=pjActionSaveCity&id={:id}",
					select: {
						field: "id",
						name: "record[]"
					}
				});
			}
		}
	});
})(jQuery_1_8_2);