<?php
if($tpl['status'] == 200)
{
	if(isset($tpl['location_arr']))
	{
		?>
		<div style="font-weight: bold; margin-bottom: 10px; overflow: hidden;">
			<div style="float: left;"><?php __('lblLocation')?>:&nbsp;<?php echo $tpl['location_arr']['location'];?></div>
		</div>
		<?php
	} 
	?>
	<div style="font-weight: bold; margin-bottom: 10px; overflow: hidden;">
		<div style="float: left;"><?php __('lblTotalPassengers')?>:&nbsp;<?php echo $tpl['total_passengers'];?></div>
	</div>
	<?php
	foreach($tpl['ticket_arr'] as $v)
	{
		?>
		<div style="font-weight: bold; margin-bottom: 10px; overflow: hidden;">
			<div style="float: left;"><?php echo $v['title']; ?>:&nbsp;<?php echo $v['total_tickets']; ?></div>
		</div>
		<?php
	} 
	?>
	<div style="font-weight: bold; margin-bottom: 10px; overflow: hidden; display: none;">
		<div style="float: left;"><?php __('lblTotalBookings')?>:&nbsp;<?php echo $tpl['total_bookings'];?></div>
	</div>
	<div style="font-weight: bold; margin-bottom: 10px; overflow: hidden;">
		<div style="float: left;"><?php __('lblBus')?>:&nbsp;<?php echo $tpl['bus_arr']['route']?>, <?php echo pjUtil::formatTime($tpl['bus_arr']['departure_time'], 'H:i:s', $tpl['option_arr']['o_time_format'])?> - <?php echo pjUtil::formatTime($tpl['bus_arr']['arrival_time'], 'H:i:s', $tpl['option_arr']['o_time_format'])?></div>
		<div style="float: right;"><?php __('lblDate')?>:&nbsp;<?php echo !empty($_GET['date']) ? date($tpl['option_arr']['o_date_format'], strtotime($_GET['date'])) : '';?></div>
	</div>
	
	<table class="table" cellspacing="0" cellpadding="0" style="width: 100%;">
		<thead>
			<tr>
				<th style="width: 40px;"><?php __('lblPassengerNo');?></th>
				<th style="width: 120px;"><?php __('lblPassengerPassengerName');?></th>
				<th><?php __('lblPassengerCountry');?></th>
				<th><?php __('lblPassengerBookingID');?></th>
				<th><?php __('lblFrom');?></th>
				<th><?php __('lblTo');?></th>
				<th><?php __('lblPassengerTicketType');?></th>
				<th><?php __('lblSeats');?></th>
				<th><?php __('lblPassengerSalesAgents');?></th>
			</tr>
		</thead>
		<tbody>
			<?php
			if(count($tpl['booking_arr']) > 0)
			{
				$person_titles = __('personal_titles', true, false);
				$count = 1;
				foreach($tpl['booking_arr'] as $v)
				{
					$tickets = $v['tickets'];
					$cnt_tickets = count($tickets);
					$seats = join(", ", $v['seats']);
					$client_name_arr = array();
					if(!empty($v['c_title']))
					{
						$client_name_arr[] = $person_titles[$v['c_title']];
					}
					if(!empty($v['c_fname']))
					{
						$client_name_arr[] = pjSanitize::clean($v['c_fname']);
					}
					if(!empty($v['c_lname']))
					{
						$client_name_arr[] = pjSanitize::clean($v['c_lname']);
					}
					if ($v['booking_ticket']) {
						foreach ($v['booking_ticket'] as $k => $bt) { 
							if($k == 0) {
							?>
							<tr>
								<td colspan="2" rowspan="<?php echo $cnt_tickets;?>" style="padding: 0;">
									<?php if ($v['seats_data']) { ?>
										<table class="pj-inner-table" cellspacing="0" cellpadding="0" style="width: 100%;">
										<?php foreach ($v['seats_data'] as $j => $bs) { ?>
											<tr>
												<td style="width: 40px;"><?php echo $count;?></td>
												<td style="width: 120px;"><?php echo pjSanitize::html($bs['name']);?></td>
											</tr>								
										<?php $count++;} ?>
										</table>
									<?php } ?>
								</td>
								<td rowspan="<?php echo $cnt_tickets;?>"><?php echo pjSanitize::html($v['country_title']);?></td>
								<td rowspan="<?php echo $cnt_tickets;?>"><?php echo pjSanitize::html($v['uuid']);?></td>
								<td rowspan="<?php echo $cnt_tickets;?>"><?php echo pjSanitize::clean($v['from_location']);?></td>
								<td rowspan="<?php echo $cnt_tickets;?>"><?php echo pjSanitize::clean($v['to_location']);?></td>
								<td><?php echo pjSanitize::html($bt['ticket']);?> x <?php echo $bt['qty'];?></td>
								<td rowspan="<?php echo $cnt_tickets;?>" align="center"><?php echo count($v['seats_data']);?></td>
								<td rowspan="<?php echo $cnt_tickets;?>"><?php echo !empty($v['agent_email']) ? (pjSanitize::html($v['agent_name']).'('.pjSanitize::html($v['agent_email']).')') : null;?></td>
							</tr>
							<?php 
							} else { ?>
							<tr>
								<td><?php echo pjSanitize::html($bt['ticket']);?> x <?php echo $bt['qty'];?></td>
							</tr>
							<?php 
							}
						}
					}
				} ?>
				<tr class="pj-total-seats">
					<td colspan="6">&nbsp;</td>
					<td><?php __('lblPassengerTotalSeats');?></td>
					<td colspan="2"><?php echo ($count-1);?></td>
				</tr>
				<?php 
			} else {
				?>
				<tr>
					<td colspan="9"><?php __('gridEmptyResult');?></td>
				</tr>
				<?php
			}
			?>
		</tbody>
	</table>
	<?php
}else{
	$print_statuses = __('print_statuses', true, false);
	?><div style="margin-bottom: 12px; overflow: hidden;"><?php echo $print_statuses[$tpl['status']]?></div><?php
} 
?>