<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	if (isset($_GET['err']))
	{
		$titles = __('error_titles', true);
		$bodies = __('error_bodies', true);
		pjUtil::printNotice(@$titles[$_GET['err']], @$bodies[$_GET['err']]);
	}
	$week_start = isset($tpl['option_arr']['o_week_start']) && in_array((int) $tpl['option_arr']['o_week_start'], range(0,6)) ? (int) $tpl['option_arr']['o_week_start'] : 0;
	$jqDateFormat = pjUtil::jqDateFormat($tpl['option_arr']['o_date_format']);
	$str_disabled = $controller->isViewer() ? 'disabled="disabled"' : '';
	?>
	<div class="bold b10 fs14"><?php __('lblRoute'); ?>: <?php echo pjSanitize::html($tpl['route_arr']['title']);?></div>
	<?php
	include_once PJ_VIEWS_PATH . 'pjLayouts/elements/submenu.php';
	pjUtil::printNotice(__('infoNotOperatingTitle', true, false), __('infoNotOperatingDesc', true, false)); 
	?>
	<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminBuses&amp;action=pjActionNotOperating" method="post" id="frmNotOperating" class="pj-form form">
		<input type="hidden" name="bus_update" value="1" />
		<input type="hidden" id="id" name="id" value="<?php echo $tpl['arr']['id']?>" />
		
		<div class="b5">
			<label class="title"><?php __('lblNotOperatingOn'); ?>:</label>
			<div class="float_left l5" id="bs_date_container">
				<label class="pjBrsNoDates block t5" style="display: none;"><?php __('lblNoDatesAdded');?></label>
				<?php
				foreach($tpl['date_arr'] as $v)
				{
					$index = 'bs_' . rand(1, 999999);
					?>
					<p>
						<span class="float_left">
							<label class="float_left r10 t10"><?php __('lblFrom');?></label>
							<span class="inline-block">
								<span class="pj-form-field-custom pj-form-field-custom-after float_left r5">
									<input type="text" <?php echo $str_disabled;?> name="date_from[<?php echo $index;?>]" id="date_from_<?php echo $index;?>" value="<?php echo pjUtil::formatDate($v['date_from'], "Y-m-d", $tpl['option_arr']['o_date_format']); ?>" class="pj-form-field pointer w80 datepick required" readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" />
									<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
								</span>
							</span>
						</span>
						<span class="float_left">
							<label class="float_left l10 r10 t10"><?php __('lblTo');?></label>
							<span class="inline-block">
								<span class="pj-form-field-custom pj-form-field-custom-after float_left r5">
									<input type="text" <?php echo $str_disabled;?> name="date_to[<?php echo $index;?>]" id="date_to_<?php echo $index;?>" value="<?php echo pjUtil::formatDate($v['date_to'], "Y-m-d", $tpl['option_arr']['o_date_format']); ?>" class="pj-form-field pointer w80 datepick required" readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" />
									<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
								</span>
								<?php if (!$controller->isViewer()) { ?>
									<input type="button" value="<?php __('btnRemove'); ?>" class="pj-button pj-button-remove-date" />
								<?php } ?>
							</span>
						</span>
					</p>
					<?php
				}
				if(isset($_GET['date']))
				{
					$index = 'bs_' . rand(1, 999999);
					?>
					<p>
						<span class="float_left">
							<label class="float_left r10 t10"><?php __('lblFrom');?></label>
							<span class="inline-block">
								<span class="pj-form-field-custom pj-form-field-custom-after float_left r5">
									<input type="text" <?php echo $str_disabled;?> name="date_from[<?php echo $index;?>]" id="date_from_<?php echo $index;?>" value="<?php echo $_GET['date']; ?>" class="pj-form-field pointer w80 datepick required" readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" />
									<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
								</span>
							</span>
						</span>
						<span class="float_left">
							<label class="float_left l10 r10 t10"><?php __('lblTo');?></label>
							<span class="inline-block">
								<span class="pj-form-field-custom pj-form-field-custom-after float_left r5">
									<input type="text" <?php echo $str_disabled;?> name="date_to[<?php echo $index;?>]" id="date_to_<?php echo $index;?>" value="<?php echo $_GET['date']; ?>" class="pj-form-field pointer w80 datepick required" readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" />
									<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
								</span>
								<?php if (!$controller->isViewer()) { ?>
									<input type="button" value="<?php __('btnRemove'); ?>" class="pj-button pj-button-remove-date" />
								<?php } ?>
							</span>
						</span>
					</p>
					<?php
				} 
				?>
			</div>
			<div class="clear_both"></div>
		</div>
		<?php if (!$controller->isViewer()) { ?>
		<p>
			<label class="title">&nbsp;</label>
			<input type="button" value="<?php __('btnAdd'); ?>" class="pj-button pj-button-add-date" />
			<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
		</p>
		<?php } ?>
	</form>
	
	<div id="bs_date_clone" style="display:none;">
		<p>
			<span class="float_left">
				<label class="float_left r10 t10"><?php __('lblFrom');?></label>
				<span class="inline-block">
					<span class="pj-form-field-custom pj-form-field-custom-after float_left r5">
						<input type="text" name="date_from[{INDEX}]" id="date_from_{INDEX}" class="pj-form-field pointer w80 datepick required" readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" />
						<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
					</span>
				</span>
			</span>
			<span class="float_left">
				<label class="float_left l10 r10 t10"><?php __('lblTo');?></label>
				<span class="inline-block">
					<span class="pj-form-field-custom pj-form-field-custom-after float_left r5">
						<input type="text" name="date_to[{INDEX}]" id="date_to_{INDEX}" class="pj-form-field pointer w80 datepick required" readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" />
						<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
					</span>
					<input type="button" value="<?php __('btnRemove'); ?>" class="pj-button pj-button-remove-date" />
				</span>
			</span>
		</p>
	</div>
	
	<script type="text/javascript">
	var locale_array = new Array(); 
	var myLabel = myLabel || {};
	myLabel.field_required = "<?php __('bs_field_required'); ?>";
	myLabel.timeFormat = "<?php echo $tpl['option_arr']['o_time_format']?>";
	</script>
	<?php
}
?>