
START TRANSACTION;

ALTER TABLE `bookings` MODIFY `payment_method` enum('paypal','authorize','creditcard','cash','bank','nicepay','nicepay_virtual') DEFAULT NULL;

ALTER TABLE `bookings` ADD COLUMN `bankCd` varchar(255) DEFAULT NULL AFTER `txn_id`;

INSERT INTO `options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES
(1, 'o_allow_nicepay_virtual', 2, 'Yes|No::No', NULL, 'enum', 21, 1, NULL);

INSERT INTO `fields` VALUES (NULL, 'payment_methods_ARRAY_nicepay_virtual', 'arrays', 'payment_methods_ARRAY_nicepay_virtual', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Nicepay virtual', 'script');

SET @id := (SELECT `id` FROM `fields` WHERE `key`='payment_methods_ARRAY_nicepay');
UPDATE `multi_lang` SET `content`='Nicepay credit card' WHERE `foreign_id`=@id AND `model`='pjField' AND `field`='title';

INSERT INTO `fields` VALUES (NULL, 'opt_o_allow_nicepay_virtual', 'backend', 'Options / Allow payments with Nicepay virtual', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Allow payments with Nicepay virtual', 'script');

SET @id := (SELECT `id` FROM `fields` WHERE `key`='opt_o_allow_nicepay');
UPDATE `multi_lang` SET `content`='Allow payments with Nicepay credit card' WHERE `foreign_id`=@id AND `model`='pjField' AND `field`='title';

INSERT INTO `fields` VALUES (NULL, 'front_label_nicepay_virtual_bank', 'frontend', 'Label / Bank', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Bank', 'script');

INSERT INTO `fields` VALUES (NULL, '_nicepay_virtual_bank_ARRAY_CENA', 'arrays', '_nicepay_virtual_bank_ARRAY_CENA', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Bank BCA', 'script');

INSERT INTO `fields` VALUES (NULL, '_nicepay_virtual_bank_ARRAY_BMRI', 'arrays', '_nicepay_virtual_bank_ARRAY_BMRI', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Bank Mandiri', 'script');

INSERT INTO `fields` VALUES (NULL, '_nicepay_virtual_bank_ARRAY_BNIN', 'arrays', '_nicepay_virtual_bank_ARRAY_BNIN', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Bank BNI', 'script');

INSERT INTO `fields` VALUES (NULL, '_nicepay_virtual_bank_ARRAY_HNBN', 'arrays', '_nicepay_virtual_bank_ARRAY_HNBN', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Bank KEB Hana', 'script');

INSERT INTO `fields` VALUES (NULL, '_nicepay_virtual_bank_ARRAY_BBBA', 'arrays', '_nicepay_virtual_bank_ARRAY_BBBA', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Bank Permata', 'script');

INSERT INTO `fields` VALUES (NULL, '_nicepay_virtual_bank_ARRAY_IBBK', 'arrays', '_nicepay_virtual_bank_ARRAY_IBBK', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Bank BII Maybank', 'script');

INSERT INTO `fields` VALUES (NULL, '_nicepay_virtual_bank_ARRAY_BNIA', 'arrays', '_nicepay_virtual_bank_ARRAY_BNIA', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Bank CIMB', 'script');

INSERT INTO `fields` VALUES (NULL, '_nicepay_virtual_bank_ARRAY_BRIN', 'arrays', '_nicepay_virtual_bank_ARRAY_BRIN', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Bank BRI', 'script');

INSERT INTO `fields` VALUES (NULL, '_nicepay_virtual_bank_ARRAY_BDIN', 'arrays', '_nicepay_virtual_bank_ARRAY_BDIN', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Bank Danamon', 'script');

INSERT INTO `fields` VALUES (NULL, 'front_messages_ARRAY_8', 'arrays', 'front_messages_ARRAY_8', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Your booking is saved. Please wait while processing your payment...', 'script');

COMMIT;