
START TRANSACTION;

ALTER TABLE `bookings` ADD COLUMN `user_id` int(10) unsigned DEFAULT NULL AFTER `uuid`;
ALTER TABLE `bookings` ADD COLUMN `pickup_area_id` int(10) unsigned DEFAULT NULL;
ALTER TABLE `bookings` MODIFY `payment_method` enum('paypal','authorize','creditcard','cash','bank','nicepay') DEFAULT NULL;

ALTER TABLE `buses_dates` CHANGE `date` `date_from` date NOT NULL DEFAULT '0000-00-00';
ALTER TABLE `buses_dates` ADD COLUMN `date_to` date NOT NULL DEFAULT '0000-00-00';

INSERT INTO `roles` (`id`, `role`, `status`) VALUES
(3, 'agent', 'T'),
(4, 'view', 'T');

DROP TABLE IF EXISTS `buses_block_seats`;
CREATE TABLE IF NOT EXISTS `buses_block_seats` (
  `bus_id` int(10) unsigned DEFAULT NULL,
  `date` date DEFAULT NULL,
  `seats` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`bus_id`,`date`),
  KEY `bus_id` (`bus_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `route_blocks`;
CREATE TABLE IF NOT EXISTS `route_blocks` (
  `route_id` int(10) unsigned DEFAULT NULL,
  `from_location_id` int(10) DEFAULT NULL,
  `to_location_id` int(10) DEFAULT NULL,
  PRIMARY KEY (`route_id`, `from_location_id`, `to_location_id`),
  KEY `route_id` (`route_id`),
  KEY `from_location_id` (`from_location_id`),
  KEY `to_location_id` (`to_location_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `vouchers`;
CREATE TABLE IF NOT EXISTS `vouchers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(100) DEFAULT NULL,
  `type` enum('amount','percent') DEFAULT NULL,
  `discount` decimal(9,2) unsigned DEFAULT NULL,
  `valid` enum('fixed','period','recurring') DEFAULT NULL,
  `date_from` date DEFAULT NULL,
  `date_to` date DEFAULT NULL,
  `time_from` time DEFAULT NULL,
  `time_to` time DEFAULT NULL,
  `every` enum('monday','tuesday','wednesday','thursday','friday','saturday','sunday') DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `areas`;
CREATE TABLE IF NOT EXISTS `areas` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT, 
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

ALTER TABLE `bookings` ADD COLUMN `voucher_code` varchar(255) DEFAULT NULL;
ALTER TABLE `bookings` ADD COLUMN `voucher_value` decimal(9,2) unsigned DEFAULT NULL;
ALTER TABLE `bookings` ADD COLUMN `voucher_processed_on` datetime DEFAULT NULL;

UPDATE `options` SET `value`='1|2|3::1' WHERE `key` IN('o_bf_include_company','o_bf_include_address','o_bf_include_city','o_bf_include_state','o_bf_include_zip');
UPDATE `options` SET `value`='1|2|3::2' WHERE `key` IN('o_bf_include_notes','o_bf_include_country');

INSERT INTO `options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES
(1, 'o_min_hour_prior_departure', 2, '3', NULL, 'int', 8, 1, NULL),
(1, 'o_bf_include_area', 4, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 14, 1, NULL),
(1, 'o_allow_nicepay', 2, 'Yes|No::No', NULL, 'enum', 21, 1, NULL),
(1, 'o_nicepay_merchant_id', 2, '', NULL, 'string', 22, 1, NULL),
(1, 'o_nicepay_merchant_key', 2, '', NULL, 'string', 23, 1, NULL);

INSERT INTO `fields` VALUES (NULL, 'lblReturnTicketPrice', 'backend', 'Label / Return ticket price', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Return ticket price', 'script');

INSERT INTO `fields` VALUES (NULL, 'opt_o_min_hour_prior_departure', 'backend', 'Options / Booking XX hours prior to departure', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Booking XX hours prior to departure', 'script');

INSERT INTO `fields` VALUES (NULL, 'lblBlockSeats', 'backend', 'Label / Block Seats', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Block Seats', 'script');

INSERT INTO `fields` VALUES (NULL, 'lblBlockSeatDate', 'backend', 'Label / Date', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Date', 'script');

INSERT INTO `fields` VALUES (NULL, 'lblBlockSeatBlock', 'backend', 'Label / Block', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Block', 'script');

INSERT INTO `fields` VALUES (NULL, 'lblBlockSeatSeats', 'backend', 'Label / seats', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'seats', 'script');

INSERT INTO `fields` VALUES (NULL, 'error_titles_ARRAY_ABS12', 'arrays', 'error_titles_ARRAY_ABS12', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Block seats set', 'script');

INSERT INTO `fields` VALUES (NULL, 'error_bodies_ARRAY_ABS12', 'arrays', 'error_bodies_ARRAY_ABS12', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Block seats that you defined have been saved successfully.', 'script');

INSERT INTO `fields` VALUES (NULL, 'infoBlockSeatsTitle', 'backend', 'Infobox / Block seats set', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Block seats set', 'script');

INSERT INTO `fields` VALUES (NULL, 'infoBlockSeatsDesc', 'backend', 'Infobox / Block seats set', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Below you can define a list of block seats. This way you can manage better the bus schedule and forbid bookings on dates that are within the bus operating period of time. To add more block seats on the list use the "Add +" button.', 'script');

INSERT INTO `fields` VALUES (NULL, 'lblNoBlockSeatsAdded', 'backend', 'Label / No block seats added', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'No block seats added', 'script');

INSERT INTO `fields` VALUES (NULL, 'lblRouteBlocks', 'backend', 'Label / Blocks', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Blocks', 'script');

INSERT INTO `fields` VALUES (NULL, 'lblRouteBlocksTo', 'backend', 'Label / to', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'to', 'script');

INSERT INTO `fields` VALUES (NULL, 'lblAddRouteBlocks', 'backend', 'Label / Add blocks', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Add blocks', 'script');

INSERT INTO `fields` VALUES (NULL, 'menuVouchers', 'backend', 'Menu / Vouchers', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Vouchers', 'script');

INSERT INTO `fields` VALUES (NULL, 'error_titles_ARRAY_AVO01', 'arrays', 'error_titles_ARRAY_AVO01', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Voucher updated', 'script');

INSERT INTO `fields` VALUES (NULL, 'error_bodies_ARRAY_AVO01', 'arrays', 'error_bodies_ARRAY_AVO01', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'All changes made to the voucher have been saved.', 'script');

INSERT INTO `fields` VALUES (NULL, 'error_titles_ARRAY_AVO03', 'arrays', 'error_titles_ARRAY_AVO03', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Voucher added', 'script');

INSERT INTO `fields` VALUES (NULL, 'error_bodies_ARRAY_AVO03', 'arrays', 'error_bodies_ARRAY_AVO03', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'New voucher has been added to the list.', 'script');

INSERT INTO `fields` VALUES (NULL, 'error_titles_ARRAY_AVO04', 'arrays', 'error_titles_ARRAY_AVO04', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Voucher failed to add', 'script');

INSERT INTO `fields` VALUES (NULL, 'error_bodies_ARRAY_AVO04', 'arrays', 'error_bodies_ARRAY_AVO04', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'We are sorry that new voucher could not bee added successfully.', 'script');

INSERT INTO `fields` VALUES (NULL, 'error_titles_ARRAY_AVO08', 'arrays', 'error_titles_ARRAY_AVO08', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Voucher not found', 'script');

INSERT INTO `fields` VALUES (NULL, 'error_bodies_ARRAY_AVO08', 'arrays', 'error_bodies_ARRAY_AVO08', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'We are sorry that voucher you are looking for is missing.', 'script');

INSERT INTO `fields` VALUES (NULL, 'lblAddVoucher', 'backend', 'Label / Add voucher', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Add voucher', 'script');

INSERT INTO `fields` VALUES (NULL, 'infoVoucherListTitle', 'backend', 'Infobox / Voucher List', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Voucher list', 'script');

INSERT INTO `fields` VALUES (NULL, 'infoVoucherListDesc', 'backend', 'Infobox / Voucher List', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Below is a list of all vouchers added to the system. Voucher is a series of numbers or letters that will grant your users a certain discount of the regular price if added during the checkout. To add  new voucher click on the tab above. To edit voucher click on the pencil icon of the row.', 'script');

INSERT INTO `fields` VALUES (NULL, 'lblDiscount', 'backend', 'Label / Discount', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Discount', 'script');

INSERT INTO `fields` VALUES (NULL, 'lblValid', 'backend', 'Label / Valid', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Valid', 'script');

INSERT INTO `fields` VALUES (NULL, 'infoAddVoucherTitle', 'backend', 'Infobox / Add Voucher', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Add new voucher', 'script');

INSERT INTO `fields` VALUES (NULL, 'infoAddVoucherDesc', 'backend', 'Infobox / Add Voucher', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Use the form below to create vouchers for discount.', 'script');

INSERT INTO `fields` VALUES (NULL, 'lblTimeFrom', 'backend', 'Label / Time from', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Time from', 'script');

INSERT INTO `fields` VALUES (NULL, 'lblTimeTo', 'backend', 'Label / Time to', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Time to', 'script');

INSERT INTO `fields` VALUES (NULL, 'lblValidateTime', 'backend', 'Label / Validate time', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'End time must be greater than start time.', 'script');

INSERT INTO `fields` VALUES (NULL, 'lblDateTimeFrom', 'backend', 'Label / Validate time', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'From date/time', 'script');

INSERT INTO `fields` VALUES (NULL, 'lblDateTimeTo', 'backend', 'Label / To date/time', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'To date/time', 'script');

INSERT INTO `fields` VALUES (NULL, 'lblValidateVoucherDateTime', 'backend', 'Label / Validate date time', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'From date/time must be greater than To date/time.', 'script');

INSERT INTO `fields` VALUES (NULL, 'lblEvery', 'backend', 'Label / Every', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Every', 'script');

INSERT INTO `fields` VALUES (NULL, 'voucher_days_ARRAY_monday', 'arrays', 'voucher_days_ARRAY_monday', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Monday', 'script');

INSERT INTO `fields` VALUES (NULL, 'voucher_days_ARRAY_tuesday', 'arrays', 'voucher_days_ARRAY_tuesday', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Tuesday', 'script');

INSERT INTO `fields` VALUES (NULL, 'voucher_days_ARRAY_wednesday', 'arrays', 'voucher_days_ARRAY_wednesday', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Wednesday', 'script');

INSERT INTO `fields` VALUES (NULL, 'voucher_days_ARRAY_thursday', 'arrays', 'voucher_days_ARRAY_thursday', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Thursday', 'script');

INSERT INTO `fields` VALUES (NULL, 'voucher_days_ARRAY_friday', 'arrays', 'voucher_days_ARRAY_friday', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Friday', 'script');

INSERT INTO `fields` VALUES (NULL, 'voucher_days_ARRAY_saturday', 'arrays', 'voucher_days_ARRAY_saturday', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Saturday', 'script');

INSERT INTO `fields` VALUES (NULL, 'voucher_days_ARRAY_sunday', 'arrays', 'voucher_days_ARRAY_sunday', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Sunday', 'script');

INSERT INTO `fields` VALUES (NULL, 'lblVoucherCodeExist', 'backend', 'Label / Voucher code exist', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'The voucher code was already used.', 'script');

INSERT INTO `fields` VALUES (NULL, 'lblUpdateVoucher', 'backend', 'Label / Update voucher', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Update voucher', 'script');

INSERT INTO `fields` VALUES (NULL, 'infoUpdateVoucherTitle', 'backend', 'Label / Update Voucher', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Update Voucher', 'script');

INSERT INTO `fields` VALUES (NULL, 'infoUpdateVoucherDesc', 'backend', 'Label / Update Voucher', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Please make any change you want on the form below to update voucher information and click SAVE button.', 'script');

INSERT INTO `fields` VALUES (NULL, 'voucher_types_ARRAY_amount', 'arrays', 'voucher_types_ARRAY_amount', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Amount', 'script');

INSERT INTO `fields` VALUES (NULL, 'voucher_types_ARRAY_percent', 'arrays', 'voucher_types_ARRAY_percent', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Percent', 'script');

INSERT INTO `fields` VALUES (NULL, 'voucher_valids_ARRAY_fixed', 'arrays', 'voucher_valids_ARRAY_fixed', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Fixed', 'script');

INSERT INTO `fields` VALUES (NULL, 'voucher_valids_ARRAY_period', 'arrays', 'voucher_valids_ARRAY_period', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Period', 'script');

INSERT INTO `fields` VALUES (NULL, 'voucher_valids_ARRAY_recurring', 'arrays', 'voucher_valids_ARRAY_recurring', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Recurring', 'script');

INSERT INTO `fields` VALUES (NULL, 'lblVoucher', 'backend', 'Label / Voucher', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Voucher', 'script');

INSERT INTO `fields` VALUES (NULL, 'lblPluralVoucher', 'backend', 'Label / vouchers', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'vouchers', 'script');

INSERT INTO `fields` VALUES (NULL, 'lblSingularVoucher', 'backend', 'Label / voucher', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'voucher', 'script');

INSERT INTO `fields` VALUES (NULL, 'promo_statuses_ARRAY_100', 'arrays', 'promo_statuses_ARRAY_100', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Missing parameters', 'script');

INSERT INTO `fields` VALUES (NULL, 'promo_statuses_ARRAY_101', 'arrays', 'promo_statuses_ARRAY_101', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Promo code not found', 'script');

INSERT INTO `fields` VALUES (NULL, 'promo_statuses_ARRAY_102', 'arrays', 'promo_statuses_ARRAY_102', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Promo code is out of date', 'script');

INSERT INTO `fields` VALUES (NULL, 'promo_statuses_ARRAY_103', 'arrays', 'promo_statuses_ARRAY_103', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Date is empty', 'script');

INSERT INTO `fields` VALUES (NULL, 'promo_statuses_ARRAY_200', 'arrays', 'promo_statuses_ARRAY_200', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Promo code has been accepted', 'script');

INSERT INTO `fields` VALUES (NULL, 'lblExpire', 'backend', 'Label / Expire', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Expire', 'script');

INSERT INTO `fields` VALUES (NULL, 'lblDateTimeValid', 'backend', 'Label / Date/Time valid', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Date/Time valid', 'script');

INSERT INTO `fields` VALUES (NULL, 'lblExpirationDate', 'backend', 'Label / Expiration date', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Expiration date', 'script');


INSERT INTO `fields` VALUES (NULL, 'infoAreasTitle', 'backend', 'Infobox / Area list title', 'script', '2016-09-12 05:17:35');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Area list', 'script');

INSERT INTO `fields` VALUES (NULL, 'infoAreasDesc', 'backend', 'Infobox / Area list desc', 'script', '2016-09-12 05:17:35');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Below is the list of areas. Let click on the Add Area tab to define new area. You can also Edit or Delete a specific area by clicking on the corresponding row.', 'script');

INSERT INTO `fields` VALUES (NULL, 'infoAddAreaTitle', 'backend', 'Infobox / Add area title', 'script', '2016-09-12 05:17:35');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Add new area', 'script');

INSERT INTO `fields` VALUES (NULL, 'infoAddAreaDesc', 'backend', 'Infobox / Add area desc', 'script', '2016-09-12 05:17:35');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Please fill out the form below and click Save button to add new area. Or click on the Cancel button the go back to the area list.', 'script');

INSERT INTO `fields` VALUES (NULL, 'infoEditAreaTitle', 'backend', 'Infobox / Edit area title', 'script', '2016-09-12 05:17:35');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Edit area', 'script');

INSERT INTO `fields` VALUES (NULL, 'infoEditAreaDesc', 'backend', 'Infobox / Edit area desc', 'script', '2016-09-12 05:17:35');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'You can make any change you want on the form below and click Save button to update area name', 'script');

INSERT INTO `fields` VALUES (NULL, 'lblAreaName', 'backend', 'Label / Area', 'script', '2016-09-12 05:17:35');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Area', 'script');

INSERT INTO `fields` VALUES (NULL, 'lblSameArea', 'backend', 'Label / Same area', 'script', '2016-09-12 05:17:35');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Area name was alaredy used.', 'script');

INSERT INTO `fields` VALUES (NULL, 'btnAddArea', 'backend', 'Button / Add area', 'script', '2016-09-12 05:17:35');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', '+ Add area', 'script');

INSERT INTO `fields` VALUES (NULL, 'error_titles_ARRAY_AAR01', 'arrays', 'error_titles_ARRAY_AAR01', 'script', '2016-09-12 05:17:35');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Area updated!', 'script');

INSERT INTO `fields` VALUES (NULL, 'error_titles_ARRAY_AAR03', 'arrays', 'error_titles_ARRAY_AAR03', 'script', '2016-09-12 05:17:35');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Area added!', 'script');

INSERT INTO `fields` VALUES (NULL, 'error_titles_ARRAY_AAR04', 'arrays', 'error_titles_ARRAY_AAR04', 'script', '2016-09-12 05:17:35');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Area failed to add.', 'script');

INSERT INTO `fields` VALUES (NULL, 'error_titles_ARRAY_AAR08', 'arrays', 'error_titles_ARRAY_AAR08', 'script', '2016-09-12 05:17:35');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Area not found.', 'script');

INSERT INTO `fields` VALUES (NULL, 'error_bodies_ARRAY_AAR01', 'arrays', 'error_bodies_ARRAY_AAR01', 'script', '2016-09-12 05:17:35');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'All the changes made to the area have been saved.', 'script');

INSERT INTO `fields` VALUES (NULL, 'error_bodies_ARRAY_AAR03', 'arrays', 'error_bodies_ARRAY_AAR03', 'script', '2016-09-12 05:17:35');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'All the changes made to the area have been saved.', 'script');

INSERT INTO `fields` VALUES (NULL, 'error_bodies_ARRAY_AAR04', 'arrays', 'error_bodies_ARRAY_AAR04', 'script', '2016-09-12 05:17:35');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'We are sorry, but the area has not been added.', 'script');

INSERT INTO `fields` VALUES (NULL, 'error_bodies_ARRAY_AAR08', 'arrays', 'error_bodies_ARRAY_AAR08', 'script', '2016-09-12 05:17:35');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Area your looking for is missing.', 'script');

INSERT INTO `fields` VALUES (NULL, 'menuAreas', 'backend', 'Menu / Areas', 'script', '2016-09-12 05:17:35');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Areas', 'script');

INSERT INTO `fields` VALUES (NULL, 'lblArea', 'backend', 'Label / Area', 'script', '2016-09-12 05:17:35');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Area', 'script');

INSERT INTO `fields` VALUES (NULL, 'opt_o_bf_include_area', 'backend', 'Label / Area', 'script', '2016-09-12 05:17:35');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Area', 'script');

INSERT INTO `fields` VALUES (NULL, 'front_label_pickup_area', 'frontend', 'Label / Pick Up area', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Pick Up area', 'script');

INSERT INTO `fields` VALUES (NULL, 'lblBookingArea', 'backend', 'Label / Pick Up area', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Pick Up area', 'script');

SET @id := (SELECT `id` FROM `fields` WHERE `key` = "lblTemplateTokens");
UPDATE `multi_lang` SET `content` = '<u>Available Tokens:</u>\r\n<br/><br/>\r\n{Title}<br/>\r\n{FirstName}<br/>\r\n{LastName}<br/>\r\n{Email}<br/>\r\n{Phone}<br/>\r\n{Notes}<br/>\r\n{Country}<br/>\r\n{City}<br/>\r\n{State}<br/>\r\n{Zip}<br/>\r\n{Address}<br/>\r\n{Company}<br/>\r\n{Date}<br/>\r\n{Bus}<br/>\r\n{Route}<br/>\r\n{Seat}<br/>\r\n{Time}<br/>\r\n{From_Location}<br/>\r\n{To_Location}<br/>\r\n{Return_Date}<br/>\r\n{Departure_Time}<br/>\r\n{Arrival_Time}<br/>\r\n{TicketType}<br/>\r\n{TotalTicketType}<br/>\r\n{UniqueID}<br/>\r\n{Total}<br/>{Tax}<br/>{DiscountCode}<br/>{DiscountValue}<br/>\r\n{PaymentMethod}<br/>\r\n{CCType}<br/>\r\n{CCNum}<br/>\r\n{CCExp}<br/>\r\n{CCSec}<br/>\r\n{CancelURL}<br/>' WHERE `foreign_id` = @id AND `model` = "pjField" AND `field` = "title";

SET @id := (SELECT `id` FROM `fields` WHERE `key` = "opt_o_email_confirmation_message_text");
UPDATE `multi_lang` SET `content` = '<u>Available Tokens:</u><br/><br/>{Title}<br/>{FirstName}<br/>{LastName}<br/>{Email}<br/>{Phone}<br/>{Notes}<br/>{Country}<br/>{City}<br/>{State}<br/>{Zip}<br/>{Address}<br/>{Company}<br/>{Date}<br/>{Time}<br/>{Bus}<br/>{Route}<br/>{From_Location}<br/>{To_Location}<br/>{Return_Date}<br/>{Seats}<br/>{TicketTypesPrice}<br/>{TotalTicketType}<br/>{UniqueID}<br/>{Total}<br/>{Tax}<br/>{DiscountCode}<br/>{DiscountValue}<br/>{PaymentMethod}<br/>{CCType}<br/>{CCNum}<br/>{CCExp}<br/>{CCSec}<br/>{PrintTickets}<br/>{CancelURL}<br/>' WHERE `foreign_id` = @id AND `model` = "pjField" AND `field` = "title";

SET @id := (SELECT `id` FROM `fields` WHERE `key` = "opt_o_email_payment_message_text");
UPDATE `multi_lang` SET `content` = '<u>Available Tokens:</u><br/><br/>{Title}<br/>{FirstName}<br/>{LastName}<br/>{Email}<br/>{Phone}<br/>{Notes}<br/>{Country}<br/>{City}<br/>{State}<br/>{Zip}<br/>{Address}<br/>{Company}<br/>{Date}<br/>{Time}<br/>{Bus}<br/>{Route}<br/>{From_Location}<br/>{To_Location}<br/>{Return_Date}<br/>{Seats}<br/>{TicketTypesPrice}<br/>{TotalTicketType}<br/>{UniqueID}<br/>{Total}<br/>{Tax}<br/>{DiscountCode}<br/>{DiscountValue}<br/>{PaymentMethod}<br/>{CCType}<br/>{CCNum}<br/>{CCExp}<br/>{CCSec}<br/>{PrintTickets}<br/>{CancelURL}<br/>' WHERE `foreign_id` = @id AND `model` = "pjField" AND `field` = "title";

SET @id := (SELECT `id` FROM `fields` WHERE `key` = "opt_o_email_cancel_message_text");
UPDATE `multi_lang` SET `content` = '<u>Available Tokens:</u><br/><br/>{Title}<br/>{FirstName}<br/>{LastName}<br/>{Email}<br/>{Phone}<br/>{Notes}<br/>{Country}<br/>{City}<br/>{State}<br/>{Zip}<br/>{Address}<br/>{Company}<br/>{Date}<br/>{Time}<br/>{Bus}<br/>{Route}<br/>{From_Location}<br/>{To_Location}<br/>{Return_Date}<br/>{Seats}<br/>{TicketTypesPrice}<br/>{TotalTicketType}<br/>{UniqueID}<br/>{Total}<br/>{Tax}<br/>{DiscountCode}<br/>{DiscountValue}<br/>{PaymentMethod}<br/>{CCType}<br/>{CCNum}<br/>{CCExp}<br/>{CCSec}<br/>{PrintTickets}<br/>{CancelURL}<br/>' WHERE `foreign_id` = @id AND `model` = "pjField" AND `field` = "title";

SET @id := (SELECT `id` FROM `fields` WHERE `key` = "lblEmailTokens");
UPDATE `multi_lang` SET `content` = '<u>Available Tokens:</u><br/><br/>{Title}<br/>{FirstName}<br/>{LastName}<br/>{Email}<br/>{Phone}<br/>{Notes}<br/>{Country}<br/>{City}<br/>{State}<br/>{Zip}<br/>{Address}<br/>{Company}<br/>{Date}<br/>{Seat}<br/>{Bus}<br/>{Route}<br/>{From_Location}<br/>{To_Location}<br/>{Return_Date}<br/>{Time}<br/>{TicketTypesPrice}<br/>{TotalTicketType}<br/>{UniqueID}<br/>{Total}<br/>{Tax}<br/>{DiscountCode}<br/>{DiscountValue}<br/>{PaymentMethod}<br/>{CCType}<br/>{CCNum}<br/>{CCExp}<br/>{CCSec}<br/>{CancelURL}<br/>' WHERE `foreign_id` = @id AND `model` = "pjField" AND `field` = "title";

SET @id := (SELECT `id` FROM `fields` WHERE `key` = "opt_o_sms_confirmation_message_text");
UPDATE `multi_lang` SET `content` = '<u>Available Tokens:</u><br/><br/>{Title}<br/>{FirstName}<br/>{LastName}<br/>{Email}<br/>{Date}<br/>{From_Location}<br/>{To_Location}<br/>{Return_Date}<br/>{TicketTypesPrice}<br/>{TotalTicketType}<br/>{UniqueID}<br/>{Total}<br/>{Tax}<br/>{DiscountCode}<br/>{DiscountValue}<br/>{Phone}' WHERE `foreign_id` = @id AND `model` = "pjField" AND `field` = "title";

SET @id := (SELECT `id` FROM `fields` WHERE `key` = "opt_o_email_notify_message_text");
UPDATE `multi_lang` SET `content` = '<u>Available Tokens:</u><br/><br/>{Title}<br/>{FirstName}<br/>{LastName}<br/>{Email}<br/>{Phone}<br/>{Notes}<br/>{Country}<br/>{City}<br/>{State}<br/>{Zip}<br/>{Address}<br/>{Company}<br/>{Date}<br/>{Time}<br/>{Bus}<br/>{Route}<br/>{From_Location}<br/>{To_Location}<br/>{Return_Date}<br/>{Seats}<br/>{TicketTypesPrice}<br/>{TotalTicketType}<br/>{UniqueID}<br/>{Total}<br/>{Tax}<br/>{DiscountCode}<br/>{DiscountValue}<br/>{PaymentMethod}<br/>{CCType}<br/>{CCNum}<br/>{CCExp}<br/>{CCSec}<br/>{PrintTickets}<br/>{CancelURL}<br/>' WHERE `foreign_id` = @id AND `model` = "pjField" AND `field` = "title";

SET @id := (SELECT `id` FROM `fields` WHERE `key` = "opt_o_sms_payment_message_text");
UPDATE `multi_lang` SET `content` = '<u>Available Tokens:</u><br/><br/>{Title}<br/>{FirstName}<br/>{LastName}<br/>{Email}<br/>{Date}<br/>{From_Location}<br/>{To_Location}<br/>{Return_Date}<br/>{TicketTypesPrice}<br/>{TotalTicketType}<br/>{UniqueID}<br/>{Total}<br/>{Tax}<br/>{DiscountCode}<br/>{DiscountValue}<br/>{Phone}' WHERE `foreign_id` = @id AND `model` = "pjField" AND `field` = "title";

INSERT INTO `fields` VALUES (NULL, 'opt_o_allow_nicepay', 'backend', 'Options / Allow payments with Nicepay', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Allow payments with Nicepay', 'script');

INSERT INTO `fields` VALUES (NULL, 'opt_o_nicepay_merchant_id', 'backend', 'Options / Nicepay merchant ID', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Nicepay merchant ID', 'script');

INSERT INTO `fields` VALUES (NULL, 'opt_o_nicepay_merchant_key', 'backend', 'Options / Nicepay merchant key', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Nicepay merchant key', 'script');

INSERT INTO `fields` VALUES (NULL, 'payment_methods_ARRAY_nicepay', 'arrays', 'payment_methods_ARRAY_nicepay', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Nicepay', 'script');

INSERT INTO `fields` VALUES (NULL, 'front_messages_ARRAY_7', 'arrays', 'front_messages_ARRAY_7', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Your booking is saved. Redirecting to Nicepay...', 'script');

INSERT INTO `fields` VALUES (NULL, 'front_btn_goto_payment_page', 'frontend', 'Button / Go to secure payment page', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Go to secure payment page', 'script');

INSERT INTO `fields` VALUES (NULL, 'front_promo_code', 'frontend', 'Label / Promo code', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Promo code', 'script');

INSERT INTO `fields` VALUES (NULL, 'front_btn_apply', 'frontend', 'Button / Apply', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Apply', 'script');

INSERT INTO `fields` VALUES (NULL, 'front_discount', 'frontend', 'Label / Discount', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Discount', 'script');

INSERT INTO `fields` VALUES (NULL, 'btnCalcPrice', 'backend', 'Button / Calculate price', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Calculate price', 'script');

INSERT INTO `fields` VALUES (NULL, 'lblPromoCode', 'backend', 'Label / Promo code', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Promo code', 'script');

INSERT INTO `fields` VALUES (NULL, 'lblDiscountValue', 'backend', 'Label / Discount', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `multi_lang` VALUES (NULL, @id, 'pjField', '::LOCALE::', 'title', 'Discount', 'script');



COMMIT;